//=============================================================================
// VisuStella MZ - Variable Gauges
// VisuMZ_4_VariableGauges.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_4_VariableGauges = true;

var VisuMZ = VisuMZ || {};
VisuMZ.VariableGauges = VisuMZ.VariableGauges || {};
VisuMZ.VariableGauges.version = 1.01;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 4] [Version 1.01] [VariableGauges]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Main_Page
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * This plugin allows you, the game dev, to place gauges on the screen whose
 * values are governed by variables. These gauges can appear on the map screen
 * or the battle screen to your liking. Their maximum values, placements, type,
 * colors, and more can be adjusted to suit your needs. Mark them with icons
 * and have tooltip windows appear explaining their purpose when the player
 * hovers the mouse cursor over them.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Display an unlimited number of Variable Gauges on the screen.
 * * Variable Gauges will automatically update when their assigned variables
 *   are updated through event commands.
 * * Adjust their screen position, colors, horizontal or vertical style type.
 * * Mark the gauges with icons to let the player distinguish them quickly.
 * * Provide tooltip support for when the player hovers the mouse cursor over
 *   them for more clarity on what the gauges are for.
 * * Adjust their visibility through Plugin Commands and Notetags.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 4 ------
 *
 * This plugin is a Tier 4 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_MessageCore
 * 
 * Word Wrap does not work the tooltips. This is because the tooltips are
 * automatically sized based on the text at hand.
 * 
 * ---
 * 
 * VisuMZ_3_MessageKeywords
 * 
 * Message Keywords do not work with the tooltips because you cannot hover the
 * mouse cursor over a window that only appears when hovering over a specific
 * section of the screen.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * ---
 * 
 * === Map-Related Notetags ===
 * 
 * ---
 *
 * <Hide Variable Gauges>
 *
 * - Used for: Map Notetags
 * - Prevents Variable Gauges from being visible on the current map.
 *
 * ---
 *
 * <Force Variable Gauge: key>
 * <Force Variable Gauges: key, key, key>
 *
 * - Used for: Map Notetags
 * - Overrides map settings for the visible Variable Gauges and makes it so
 *   that only the listed Variable Gauges (marked by their keys) are visible
 *   while on this map.
 * - No other Variable Gauges are visible while on this map.
 * - Replace 'key' with a string representing the Variable Gauge that should be
 *   visible on the map.
 *
 * ---
 *
 * <Extra Variable Gauge: key>
 * <Extra Variable Gauges: key, key, key>
 *
 * - Used for: Map Notetags
 * - Shows extra Variable Gauge(s) in addition to the ones that are normally
 *   visible on the map while on this map.
 * - Replace 'key' with a string representing the Variable Gauge that is also
 *   visible on the map.
 *
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Battle Plugin Commands ===
 * 
 * ---
 *
 * Battle: Add Variable Gauge(s)
 * - Adds Variable Gauge(s) to be visible in battle.
 *
 *   Key(s):
 *   - List the key(s) of the Variable Gauge(s) you want visible in battle.
 *
 * ---
 *
 * Battle: Remove Variable Gauge(s)
 * - Remove Variable Gauge(s) from view in battle.
 *
 *   Key(s):
 *   - List the key(s) of the Variable Gauge(s) you want removed from battle.
 *
 * ---
 *
 * Battle: Remove All Gauge(s)
 * - Remove All Variable Gauge(s) from view in battle.
 *
 * ---
 * 
 * === Map Plugin Commands ===
 * 
 * ---
 *
 * Map: Add Variable Gauge(s)
 * - Adds Variable Gauge(s) to be visible on the map.
 *
 *   Key(s):
 *   - List the key(s) of the Variable Gauge(s) you want visible on the map.
 *
 * ---
 *
 * Map: Remove Variable Gauge(s)
 * - Remove Variable Gauge(s) from view in battle.
 *
 *   Key(s):
 *   - List the key(s) of the Variable Gauge(s) you want removed from the
 *     map scene.
 *
 * ---
 *
 * Map: Remove All Gauge(s)
 * - Remove All Variable Gauge(s) from view on the map.
 *
 * ---
 * 
 * === Refresh Plugin Commands ===
 * 
 * ---
 *
 * Refresh: All Variable Gauge(s)
 * - Refresh all Variable Gauges currently visible.
 *
 * ---
 *
 * Refresh: Target Variable Gauge(s)
 * - Refresh Target Variable Gauges currently visible.
 *
 *   Key(s):
 *   - List the key(s) of the Variable Gauge(s) you want refreshed.
 *
 * ---
 * 
 * === System Plugin Commands ===
 * 
 * ---
 *
 * System: Variable Gauge Visibility
 * - Shows/hides all variable gauges on the screen.
 *
 *   Visibility:
 *   - Shows/hides all Variable Gauges on the screen.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Gauge List Settings
 * ============================================================================
 *
 * A list of the gauges you wish to show on screen. Here is where you adjust
 * ALL of the settings related to the Variable Gauges that can appear in your
 * game. Every setting needs to be carefully adjusted.
 *
 * ---
 *
 * Main
 * 
 *   Key:
 *   - Identification key used to reference this gauge.
 *   - Use unique keys for this to work.
 *   - If you do not change the ID Key for this Variable Gauge and leave it as
 *     >>>ATTENTION<<<, then the game will not let you move forward.
 * 
 *   Variable ID:
 *   - Select a variable to bind this gauge to.
 *   - Use a Variable ID other than 0 for this to work.
 * 
 *   JS: Maximum Value:
 *   - Code used to determine the maximum value for the gauge.
 *
 * ---
 *
 * Gauge Colors
 * 
 *   Color 1:
 *   Color 2:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 *
 * ---
 *
 * Default Visibility
 * 
 *   Map Visible:
 *   Battle Visible:
 *   - Do you want this gauge to be visible or hidden by default?
 *
 * ---
 *
 * Icon Settings
 * 
 *   Icon Index:
 *   - Pairs the gauge with an icon.
 *   - Use 0 to not use any icons.
 * 
 *   Icon Buffer:
 *   - Pixel distance to buffer icon from gauge.
 *   - Direction depends on Gauge Type.
 *
 * ---
 *
 * Screen Settings
 * 
 *   Gauge Type:
 *   - What is the gauge type like?
 *     - Horizontal - Goes Left to Right
 *     - Vertical - Goes Down to Up
 * 
 *   JS: Position:
 *   - Code used to determine the screen position for this gauge.
 *
 * ---
 *
 * Tooltip Settings
 * 
 *   Tooltip Text:
 *   - Tooltip text that's displayed when the mouse hovers over.
 *   - Text codes allowed. Does not work with Word Wrap.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Tooltip Settings
 * ============================================================================
 *
 * Settings for the Variable Gauges Tooltips Window.
 *
 * ---
 *
 * Appearance
 * 
 *   Scale:
 *   - What scale size do you want for the tooltip?
 *   - Use 1.0 for normal size.
 * 
 *   Skin Filename:
 *   - What window skin do you want to use for the tooltip?
 * 
 *   Skin Opacity:
 *   - What opacity setting is used for the tooltip?
 *   - Use a number between 0 and 255.
 *
 * ---
 *
 * Offset
 * 
 *   Offset X:
 *   - Offset the tooltip X position from the mouse?
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offset the tooltip Y position from the mouse?
 *   - Negative: up. Positive: down.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Arisu
 * * Olivia
 * * Irina
 * * Yanfly
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.01: January 20, 2022
 * * Feature Update!
 * ** Added fail safes for event test play to prevent crashes on maps without
 *    any tilesets assigned. Update made by Arisu.
 *
 * Version 1.00 Official Release Date: February 11, 2022
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BattleAddGauge
 * @text Battle: Add Variable Gauge(s)
 * @desc Adds Variable Gauge(s) to be visible in battle.
 *
 * @arg Keys:arraystr
 * @text Key(s)
 * @type string[]
 * @desc List the key(s) of the Variable Gauge(s) you want visible in battle.
 * @default []
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BattleRemoveGauge
 * @text Battle: Remove Variable Gauge(s)
 * @desc Remove Variable Gauge(s) from view in battle.
 *
 * @arg Keys:arraystr
 * @text Key(s)
 * @type string[]
 * @desc List the key(s) of the Variable Gauge(s) you want removed from battle.
 * @default []
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BattleRemoveAllGauge
 * @text Battle: Remove All Gauge(s)
 * @desc Remove All Variable Gauge(s) from view in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MapAddGauge
 * @text Map: Add Variable Gauge(s)
 * @desc Adds Variable Gauge(s) to be visible on the map.
 *
 * @arg Keys:arraystr
 * @text Key(s)
 * @type string[]
 * @desc List the key(s) of the Variable Gauge(s) you want visible on the map.
 * @default []
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MapRemoveGauge
 * @text Map: Remove Variable Gauge(s)
 * @desc Remove Variable Gauge(s) from view on the map.
 *
 * @arg Keys:arraystr
 * @text Key(s)
 * @type string[]
 * @desc List the key(s) of the Variable Gauge(s) you want removed from the map scene.
 * @default []
 *
 * @ --------------------------------------------------------------------------
 *
 * @command MapRemoveAllGauge
 * @text Map: Remove All Gauge(s)
 * @desc Remove All Variable Gauge(s) from view on the map.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command RefreshAllGauges
 * @text Refresh: All Variable Gauge(s)
 * @desc Refresh all Variable Gauges currently visible.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command RefreshTargetGauges
 * @text Refresh: Target Variable Gauge(s)
 * @desc Refresh Target Variable Gauges currently visible.
 *
 * @arg Keys:arraystr
 * @text Key(s)
 * @type string[]
 * @desc List the key(s) of the Variable Gauge(s) you want refreshed.
 * @default []
 *
 * @ --------------------------------------------------------------------------
 *
 * @command SystemVariableGaugeVisibility
 * @text System: Variable Gauge Visibility
 * @desc Shows/hides all variable gauges on the screen.
 *
 * @arg Visiblility:eval
 * @text Visibility
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Shows/hides all Variable Gauges on the screen.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param VariableGauges
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Gauge:arraystruct
 * @text Gauge List
 * @type struct<Gauge>[]
 * @desc A list of the gauges you wish to show on screen.
 * @default ["{\"Key:str\":\"Example\",\"VariableID:num\":\"1\",\"MaximumJS:func\":\"\\\"// Declare Variables\\\\nlet max = 100;\\\\n\\\\n// Calculations\\\\n// Insert your calculations here\\\\n\\\\n// Return Maximum\\\\nreturn max;\\\"\",\"Colors\":\"\",\"Color1:str\":\"28\",\"Color2:str\":\"29\",\"DefaultVisible\":\"\",\"DefaultMapVisible:eval\":\"true\",\"DefaultBattleVisible:eval\":\"false\",\"IconSettings\":\"\",\"IconIndex:num\":\"23\",\"IconBuffer:num\":\"+4\",\"Screen\":\"\",\"Type:str\":\"horz\",\"PositionJS:func\":\"\\\"// Declare Variables\\\\nlet thick = 24;\\\\nlet length = 192;\\\\nlet x = Graphics.width - length - 50 - ImageManager.iconWidth - 4;\\\\nlet y = Graphics.height - thick - 50;\\\\n\\\\n// Check Horizontal\\\\nconst horz = this.isHorizontal();\\\\nconst width = horz ? length : thick;\\\\nconst height = horz ? thick : length;\\\\n\\\\n// Return Rectangle\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"TooltipSettings\":\"\",\"TooltipText:json\":\"\\\"This is an example of a \\\\\\\\c[5]Variable Gauge\\\\\\\\c[0].\\\\nIt is directly tied to \\\\\\\\c[6]Variable 1\\\\\\\\c[0] with\\\\na maximum cap of \\\\\\\\c[24]100\\\\\\\\c[0].\\\\n\\\\nThis \\\\\\\\c[5]Variable Gauge\\\\\\\\c[0] will update whenever\\\\n\\\\\\\\c[6]Variable 1\\\\\\\\c[0] is changed by \\\\\\\\c[4]Event Commands\\\\\\\\c[0].\\\"\"}","{\"Key:str\":\"Vertical\",\"VariableID:num\":\"2\",\"MaximumJS:func\":\"\\\"// Declare Variables\\\\nlet max = 100;\\\\n\\\\n// Calculations\\\\n// Insert your calculations here\\\\n\\\\n// Return Maximum\\\\nreturn max;\\\"\",\"Colors\":\"\",\"Color1:str\":\"30\",\"Color2:str\":\"31\",\"DefaultVisible\":\"\",\"DefaultMapVisible:eval\":\"true\",\"DefaultBattleVisible:eval\":\"false\",\"IconSettings\":\"\",\"IconIndex:num\":\"87\",\"IconBuffer:num\":\"+4\",\"Screen\":\"\",\"Type:str\":\"vert\",\"PositionJS:func\":\"\\\"// Declare Variables\\\\nlet thick = 24;\\\\nlet length = 192;\\\\nlet x = Graphics.width - thick - 50;\\\\nlet y = Graphics.height - length - 50 - ImageManager.iconHeight - 4;\\\\n\\\\n// Check Horizontal\\\\nconst horz = this.isHorizontal();\\\\nconst width = horz ? length : thick;\\\\nconst height = horz ? thick : length;\\\\n\\\\n// Return Rectangle\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"TooltipSettings\":\"\",\"TooltipText:json\":\"\\\"Here is another example of a \\\\\\\\c[5]Variable Gauge\\\\\\\\c[0],\\\\nexcept that it is \\\\\\\\c[4]vertical\\\\\\\\c[0]. This gauge is\\\\ntied to \\\\\\\\c[6]Variable 2\\\\\\\\c[0].\\\\n\\\\nA \\\\\\\\c[4]vertical\\\\\\\\c[0] \\\\\\\\c[5]Variable Gauge\\\\\\\\c[0] behaves similar to\\\\na regular \\\\\\\\c[5]Variable Gauge\\\\\\\\c[0] except it is filled\\\\nfrom the bottom to the top.\\\"\"}","{\"Key:str\":\"Hidden\",\"VariableID:num\":\"3\",\"MaximumJS:func\":\"\\\"// Declare Variables\\\\nlet max = 100;\\\\n\\\\n// Calculations\\\\n// Insert your calculations here\\\\n\\\\n// Return Maximum\\\\nreturn max;\\\"\",\"Colors\":\"\",\"Color1:str\":\"20\",\"Color2:str\":\"21\",\"DefaultVisible\":\"\",\"DefaultMapVisible:eval\":\"false\",\"DefaultBattleVisible:eval\":\"false\",\"IconSettings\":\"\",\"IconIndex:num\":\"163\",\"IconBuffer:num\":\"+4\",\"Screen\":\"\",\"Type:str\":\"horz\",\"PositionJS:func\":\"\\\"// Declare Variables\\\\nlet thick = 24;\\\\nlet length = 192;\\\\nlet x = Graphics.width - length - 50 - ImageManager.iconWidth - 4;\\\\nlet y = Graphics.height - thick - 50 - ImageManager.iconHeight - 4;\\\\n\\\\n// Check Horizontal\\\\nconst horz = this.isHorizontal();\\\\nconst width = horz ? length : thick;\\\\nconst height = horz ? thick : length;\\\\n\\\\n// Return Rectangle\\\\nreturn new Rectangle(x, y, width, height);\\\"\",\"TooltipSettings\":\"\",\"TooltipText:json\":\"\\\"This is an example of a \\\\\\\\c[5]Variable Gauge\\\\\\\\c[0]\\\\nthat is normally \\\\\\\\c[4]hidden\\\\\\\\c[0] from view until\\\\nyou, the game dev, manually \\\\\\\\c[24]add\\\\\\\\c[0] it to\\\\nthe game screen present.\\\\n\\\\nIt is based off \\\\\\\\c[6]Variable 3\\\\\\\\c[0] and will depict\\\\nthe values shown up to a cap of \\\\\\\\c[24]100\\\\\\\\c[0].\\\"\"}"]
 *
 * @param Tooltip:struct
 * @text Tooltip Settings
 * @type struct<Tooltip>
 * @desc Settings for the Variable Gauges Tooltips Window.
 * @default {"Appearance":"","Scale:num":"0.6","WindowSkin:str":"Window","WindowOpacity:num":"240","Offset":"","OffsetX:num":"+0","OffsetY:num":"+0"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Gauge:
 *
 * @param Key:str
 * @text Key
 * @desc Identification key used to reference this gauge.
 * Use unique keys for this to work.
 * @default >>>ATTENTION<<<
 *
 * @param VariableID:num
 * @text Variable ID
 * @parent Key:str
 * @type variable
 * @desc Select a variable to bind this gauge to.
 * Use a Variable ID other than 0 for this to work.
 * @default 0
 *
 * @param MaximumJS:func
 * @text JS: Maximum Value
 * @parent Key:str
 * @type note
 * @desc Code used to determine the maximum value for the gauge.
 * @default "// Declare Variables\nlet max = 100;\n\n// Calculations\n// Insert your calculations here\n\n// Return Maximum\nreturn max;"
 * 
 * @param Colors
 * @text Gauge Colors
 *
 * @param Color1:str
 * @text Color 1
 * @parent Colors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 30
 *
 * @param Color2:str
 * @text Color 2
 * @parent Colors
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 31
 * 
 * @param DefaultVisible
 * @text Default Visibility
 *
 * @param DefaultMapVisible:eval
 * @text Map Visible
 * @parent DefaultVisible
 * @type boolean
 * @on Visible by Default
 * @off Hidden by Default
 * @desc Do you want this gauge to be visible or hidden by default?
 * @default true
 *
 * @param DefaultBattleVisible:eval
 * @text Battle Visible
 * @parent DefaultVisible
 * @type boolean
 * @on Visible by Default
 * @off Hidden by Default
 * @desc Do you want this gauge to be visible or hidden by default?
 * @default false
 * 
 * @param IconSettings
 * @text Icon Settings
 *
 * @param IconIndex:num
 * @text Icon Index
 * @parent IconSettings
 * @desc Pairs the gauge with an icon.
 * Use 0 to not use any icons.
 * @default 0
 *
 * @param IconBuffer:num
 * @text Icon Buffer
 * @parent IconSettings
 * @desc Pixel distance to buffer icon from gauge.
 * Direction depends on Gauge Type.
 * @default +4
 * 
 * @param Screen
 * @text Screen Settings
 *
 * @param Type:str
 * @text Gauge Type
 * @parent Screen
 * @type select
 * @option Horizontal - Goes Left to Right
 * @value horz
 * @option Vertical - Goes Down to Up
 * @value vert
 * @desc What is the gauge type like?
 * @default horz
 *
 * @param PositionJS:func
 * @text JS: Position
 * @parent Screen
 * @type note
 * @desc Code used to determine the screen position for this gauge.
 * @default "// Declare Variables\nlet thick = 24;\nlet length = 192;\nlet x = 50;\nlet y = 50;\n\n// Check Horizontal\nconst horz = this.isHorizontal();\nconst width = horz ? length : thick;\nconst height = horz ? thick : length;\n\n// Return Rectangle\nreturn new Rectangle(x, y, width, height);"
 * 
 * @param TooltipSettings
 * @text Tooltip Settings
 *
 * @param TooltipText:json
 * @text Tooltip Text
 * @parent TooltipSettings
 * @type note
 * @desc Tooltip text that's displayed when the mouse hovers over.
 * Text codes allowed. Does not work with Word Wrap.
 * @default "Example text."
 *
 */
/* ----------------------------------------------------------------------------
 * Tooltip Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Tooltip:
 *
 * @param Appearance
 *
 * @param Scale:num
 * @text Scale
 * @parent Appearance
 * @desc What scale size do you want for the tooltip?
 * Use 1.0 for normal size.
 * @default 0.6
 *
 * @param WindowSkin:str
 * @text Skin Filename
 * @parent Appearance
 * @type file
 * @dir img/system/
 * @desc What window skin do you want to use for the tooltip?
 * @default Window
 *
 * @param WindowOpacity:num
 * @text Skin Opacity
 * @parent Appearance
 * @type number
 * @min 0
 * @max 255
 * @desc What opacity setting is used for the tooltip?
 * Use a number between 0 and 255.
 * @default 240
 *
 * @param Offset
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Offset
 * @desc Offset the tooltip X position from the mouse?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Offset
 * @desc Offset the tooltip Y position from the mouse?
 * Negative: up. Positive: down.
 * @default +0
 *
 */
//=============================================================================

const _0x457acf=_0x3bc5;(function(_0x33fd14,_0x226bd9){const _0x1ddc18=_0x3bc5,_0x5233f7=_0x33fd14();while(!![]){try{const _0x20c44c=parseInt(_0x1ddc18(0x172))/0x1*(-parseInt(_0x1ddc18(0x105))/0x2)+parseInt(_0x1ddc18(0x122))/0x3*(-parseInt(_0x1ddc18(0xf8))/0x4)+parseInt(_0x1ddc18(0x130))/0x5*(-parseInt(_0x1ddc18(0x129))/0x6)+parseInt(_0x1ddc18(0x169))/0x7*(-parseInt(_0x1ddc18(0x128))/0x8)+-parseInt(_0x1ddc18(0x158))/0x9*(parseInt(_0x1ddc18(0x14a))/0xa)+-parseInt(_0x1ddc18(0x18e))/0xb+parseInt(_0x1ddc18(0x11f))/0xc;if(_0x20c44c===_0x226bd9)break;else _0x5233f7['push'](_0x5233f7['shift']());}catch(_0x28fdb6){_0x5233f7['push'](_0x5233f7['shift']());}}}(_0x3eda,0xefcbf));var label=_0x457acf(0x138),tier=tier||0x0,dependencies=[],pluginData=$plugins['filter'](function(_0x465865){const _0x20aab4=_0x457acf;return _0x465865['status']&&_0x465865[_0x20aab4(0x101)]['includes']('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x457acf(0x13b)]||{},VisuMZ['ConvertParams']=function(_0x1ede33,_0x5c4ce8){const _0x5d5876=_0x457acf;for(const _0xef8699 in _0x5c4ce8){if(_0xef8699['match'](/(.*):(.*)/i)){const _0x2945ff=String(RegExp['$1']),_0x295430=String(RegExp['$2'])['toUpperCase']()[_0x5d5876(0x118)]();let _0x4c6ecb,_0x25dde9,_0x56aba7;switch(_0x295430){case _0x5d5876(0x146):_0x4c6ecb=_0x5c4ce8[_0xef8699]!==''?Number(_0x5c4ce8[_0xef8699]):0x0;break;case _0x5d5876(0x180):_0x25dde9=_0x5c4ce8[_0xef8699]!==''?JSON[_0x5d5876(0x10d)](_0x5c4ce8[_0xef8699]):[],_0x4c6ecb=_0x25dde9[_0x5d5876(0x1ae)](_0x3d72ef=>Number(_0x3d72ef));break;case _0x5d5876(0x15b):_0x4c6ecb=_0x5c4ce8[_0xef8699]!==''?eval(_0x5c4ce8[_0xef8699]):null;break;case'ARRAYEVAL':_0x25dde9=_0x5c4ce8[_0xef8699]!==''?JSON[_0x5d5876(0x10d)](_0x5c4ce8[_0xef8699]):[],_0x4c6ecb=_0x25dde9[_0x5d5876(0x1ae)](_0x5b211a=>eval(_0x5b211a));break;case _0x5d5876(0x183):_0x4c6ecb=_0x5c4ce8[_0xef8699]!==''?JSON[_0x5d5876(0x10d)](_0x5c4ce8[_0xef8699]):'';break;case'ARRAYJSON':_0x25dde9=_0x5c4ce8[_0xef8699]!==''?JSON[_0x5d5876(0x10d)](_0x5c4ce8[_0xef8699]):[],_0x4c6ecb=_0x25dde9[_0x5d5876(0x1ae)](_0x5c5e58=>JSON[_0x5d5876(0x10d)](_0x5c5e58));break;case _0x5d5876(0x107):_0x4c6ecb=_0x5c4ce8[_0xef8699]!==''?new Function(JSON[_0x5d5876(0x10d)](_0x5c4ce8[_0xef8699])):new Function(_0x5d5876(0x18b));break;case _0x5d5876(0x150):_0x25dde9=_0x5c4ce8[_0xef8699]!==''?JSON[_0x5d5876(0x10d)](_0x5c4ce8[_0xef8699]):[],_0x4c6ecb=_0x25dde9[_0x5d5876(0x1ae)](_0x122f41=>new Function(JSON['parse'](_0x122f41)));break;case _0x5d5876(0x1a6):_0x4c6ecb=_0x5c4ce8[_0xef8699]!==''?String(_0x5c4ce8[_0xef8699]):'';break;case _0x5d5876(0x17b):_0x25dde9=_0x5c4ce8[_0xef8699]!==''?JSON[_0x5d5876(0x10d)](_0x5c4ce8[_0xef8699]):[],_0x4c6ecb=_0x25dde9[_0x5d5876(0x1ae)](_0x2bd84e=>String(_0x2bd84e));break;case _0x5d5876(0x124):_0x56aba7=_0x5c4ce8[_0xef8699]!==''?JSON['parse'](_0x5c4ce8[_0xef8699]):{},_0x4c6ecb=VisuMZ[_0x5d5876(0x1a7)]({},_0x56aba7);break;case _0x5d5876(0xff):_0x25dde9=_0x5c4ce8[_0xef8699]!==''?JSON[_0x5d5876(0x10d)](_0x5c4ce8[_0xef8699]):[],_0x4c6ecb=_0x25dde9[_0x5d5876(0x1ae)](_0x5b14ac=>VisuMZ[_0x5d5876(0x1a7)]({},JSON[_0x5d5876(0x10d)](_0x5b14ac)));break;default:continue;}_0x1ede33[_0x2945ff]=_0x4c6ecb;}}return _0x1ede33;},(_0x40bbe6=>{const _0x812f04=_0x457acf,_0x29eb86=_0x40bbe6[_0x812f04(0x119)];for(const _0x584eae of dependencies){if(!Imported[_0x584eae]){alert(_0x812f04(0x1a1)[_0x812f04(0xf9)](_0x29eb86,_0x584eae)),SceneManager['exit']();break;}}const _0x16ca00=_0x40bbe6[_0x812f04(0x101)];if(_0x16ca00['match'](/\[Version[ ](.*?)\]/i)){const _0x1fdd2e=Number(RegExp['$1']);_0x1fdd2e!==VisuMZ[label][_0x812f04(0x1b5)]&&(alert('%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.'[_0x812f04(0xf9)](_0x29eb86,_0x1fdd2e)),SceneManager['exit']());}if(_0x16ca00[_0x812f04(0x1ac)](/\[Tier[ ](\d+)\]/i)){const _0x5023c0=Number(RegExp['$1']);_0x5023c0<tier?(alert(_0x812f04(0xf1)[_0x812f04(0xf9)](_0x29eb86,_0x5023c0,tier)),SceneManager['exit']()):tier=Math[_0x812f04(0x11b)](_0x5023c0,tier);}VisuMZ[_0x812f04(0x1a7)](VisuMZ[label]['Settings'],_0x40bbe6[_0x812f04(0x137)]);})(pluginData),PluginManager['registerCommand'](pluginData[_0x457acf(0x119)],_0x457acf(0x14d),_0x149308=>{const _0x1993e9=_0x457acf;VisuMZ[_0x1993e9(0x1a7)](_0x149308,_0x149308);const _0xe714a8=_0x149308[_0x1993e9(0x14e)][_0x1993e9(0x1ae)](_0xe2b3b3=>_0xe2b3b3[_0x1993e9(0xf3)]()[_0x1993e9(0x118)]());for(const _0x445c23 of _0xe714a8){$gameSystem[_0x1993e9(0xf5)](_0x445c23);}}),PluginManager[_0x457acf(0x155)](pluginData[_0x457acf(0x119)],'BattleRemoveGauge',_0x213534=>{const _0x1fd88e=_0x457acf;VisuMZ['ConvertParams'](_0x213534,_0x213534);const _0x3ef815=_0x213534[_0x1fd88e(0x14e)]['map'](_0x2d36f8=>_0x2d36f8[_0x1fd88e(0xf3)]()['trim']());for(const _0x3ccc23 of _0x3ef815){$gameSystem['removeBattleVisibleVariableGauge'](_0x3ccc23);}}),PluginManager[_0x457acf(0x155)](pluginData['name'],'BattleRemoveAllGauge',_0x221d6a=>{const _0x55ef11=_0x457acf;VisuMZ['ConvertParams'](_0x221d6a,_0x221d6a);const _0x3a9845=$gameSystem[_0x55ef11(0x154)]||[];for(const _0x433d6f of _0x3a9845){$gameSystem['removeBattleVisibleVariableGauge'](_0x433d6f);}}),PluginManager[_0x457acf(0x155)](pluginData[_0x457acf(0x119)],'MapAddGauge',_0x1ea98=>{const _0x478c89=_0x457acf;VisuMZ[_0x478c89(0x1a7)](_0x1ea98,_0x1ea98);const _0x5543de=_0x1ea98['Keys']['map'](_0x541de6=>_0x541de6[_0x478c89(0xf3)]()[_0x478c89(0x118)]());for(const _0x5e3007 of _0x5543de){$gameSystem[_0x478c89(0x13f)](_0x5e3007);}}),PluginManager['registerCommand'](pluginData['name'],_0x457acf(0x11d),_0x2eff9e=>{const _0x2cdbf9=_0x457acf;VisuMZ[_0x2cdbf9(0x1a7)](_0x2eff9e,_0x2eff9e);const _0x34c536=_0x2eff9e[_0x2cdbf9(0x14e)][_0x2cdbf9(0x1ae)](_0x5b9a15=>_0x5b9a15['toUpperCase']()[_0x2cdbf9(0x118)]());for(const _0xbf4c5f of _0x34c536){$gameSystem[_0x2cdbf9(0x12a)](_0xbf4c5f);}}),PluginManager['registerCommand'](pluginData['name'],_0x457acf(0x1b6),_0x5df2b2=>{const _0x11c4ef=_0x457acf;VisuMZ['ConvertParams'](_0x5df2b2,_0x5df2b2);const _0x5a7807=$gameSystem[_0x11c4ef(0xfe)]||[];for(const _0x42eebe of _0x5a7807){$gameSystem['removeMapVisibleVariableGauge'](_0x42eebe);}}),PluginManager[_0x457acf(0x155)](pluginData[_0x457acf(0x119)],'RefreshAllGauges',_0x3c8f7a=>{const _0x3cd387=_0x457acf;VisuMZ[_0x3cd387(0x1a7)](_0x3c8f7a,_0x3c8f7a);const _0xbc18ca=$gameSystem[_0x3cd387(0x190)]()||[];for(const _0x132c89 of _0xbc18ca){SceneManager[_0x3cd387(0x16c)]['refreshVariableGauge'](_0x132c89);}}),PluginManager[_0x457acf(0x155)](pluginData[_0x457acf(0x119)],'RefreshTargetGauges',_0x5639e1=>{const _0x1b28f4=_0x457acf;VisuMZ[_0x1b28f4(0x1a7)](_0x5639e1,_0x5639e1);const _0x4010b4=_0x5639e1[_0x1b28f4(0x14e)]['map'](_0x31afcd=>_0x31afcd[_0x1b28f4(0xf3)]()[_0x1b28f4(0x118)]());for(const _0x11955c of _0x4010b4){SceneManager[_0x1b28f4(0x16c)][_0x1b28f4(0x18f)](_0x11955c);}}),PluginManager['registerCommand'](pluginData['name'],_0x457acf(0x186),_0x1b729f=>{const _0x1060ff=_0x457acf;VisuMZ[_0x1060ff(0x1a7)](_0x1b729f,_0x1b729f);const _0x134068=_0x1b729f[_0x1060ff(0x18a)];$gameSystem[_0x1060ff(0x15a)](_0x134068);}),VisuMZ[_0x457acf(0x138)][_0x457acf(0x151)]={'HideGauges':/<HIDE VARIABLE (?:GAUGE|GAUGES)>/i,'ForcedGauges':/<(?:FORCE|FORCED) VARIABLE (?:GAUGE|GAUGES):[ ](.*)>/i,'VisibleGauges':/<(?:EXTRA|VISIBLE) VARIABLE (?:GAUGE|GAUGES):[ ](.*)>/i},VisuMZ[_0x457acf(0x138)][_0x457acf(0x187)]=Scene_Boot[_0x457acf(0x134)]['onDatabaseLoaded'],Scene_Boot[_0x457acf(0x134)][_0x457acf(0x16e)]=function(){const _0xe604f0=_0x457acf;VisuMZ[_0xe604f0(0x138)][_0xe604f0(0x187)][_0xe604f0(0x132)](this),this['process_VisuMZ_VariableGauges']();},VisuMZ[_0x457acf(0x138)][_0x457acf(0x136)]={},VisuMZ[_0x457acf(0x138)][_0x457acf(0xf6)]=[],VisuMZ[_0x457acf(0x138)][_0x457acf(0x192)]=[],VisuMZ[_0x457acf(0x138)][_0x457acf(0x16f)]={},Scene_Boot[_0x457acf(0x134)]['process_VisuMZ_VariableGauges']=function(){const _0x4cf8a1=_0x457acf,_0x64b357=VisuMZ[_0x4cf8a1(0x138)][_0x4cf8a1(0x13b)]['Gauge'];for(const _0x417ea0 of _0x64b357){if(!_0x417ea0)continue;const _0x3d05d7=_0x417ea0[_0x4cf8a1(0x115)][_0x4cf8a1(0xf3)]()[_0x4cf8a1(0x118)]();if(_0x3d05d7===_0x4cf8a1(0x116)&&Utils[_0x4cf8a1(0x181)]('test')){let _0x2eb995=_0x4cf8a1(0x147);_0x2eb995+=_0x4cf8a1(0x117),alert(_0x2eb995),SceneManager[_0x4cf8a1(0x104)]();}if(VisuMZ['VariableGauges'][_0x4cf8a1(0x136)][_0x3d05d7])continue;VisuMZ['VariableGauges'][_0x4cf8a1(0x136)][_0x3d05d7]=_0x417ea0;_0x417ea0[_0x4cf8a1(0x109)]&&VisuMZ[_0x4cf8a1(0x138)][_0x4cf8a1(0xf6)][_0x4cf8a1(0x1a8)](_0x3d05d7);_0x417ea0[_0x4cf8a1(0x197)]&&VisuMZ[_0x4cf8a1(0x138)][_0x4cf8a1(0x192)]['push'](_0x3d05d7);const _0x5873c6=_0x417ea0['VariableID'];VisuMZ['VariableGauges']['VariableReference'][_0x5873c6]=VisuMZ[_0x4cf8a1(0x138)][_0x4cf8a1(0x16f)][_0x5873c6]||[],VisuMZ[_0x4cf8a1(0x138)]['VariableReference'][_0x5873c6][_0x4cf8a1(0x1a8)](_0x3d05d7);}},ColorManager['getColor']=function(_0x1b8ebe){const _0x228a07=_0x457acf;return _0x1b8ebe=String(_0x1b8ebe),_0x1b8ebe[_0x228a07(0x1ac)](/#(.*)/i)?'#%1'[_0x228a07(0xf9)](String(RegExp['$1'])):this['textColor'](Number(_0x1b8ebe));},SceneManager[_0x457acf(0x198)]=function(){const _0x4c7c31=_0x457acf;return this[_0x4c7c31(0x16c)]&&this['_scene'][_0x4c7c31(0x108)]===Scene_Battle;},SceneManager[_0x457acf(0x174)]=function(){const _0x5cdf7b=_0x457acf;return this[_0x5cdf7b(0x16c)]&&this[_0x5cdf7b(0x16c)][_0x5cdf7b(0x108)]===Scene_Map;},VisuMZ['VariableGauges'][_0x457acf(0x106)]=Game_System[_0x457acf(0x134)]['initialize'],Game_System[_0x457acf(0x134)][_0x457acf(0x17d)]=function(){const _0x57dfbd=_0x457acf;VisuMZ[_0x57dfbd(0x138)][_0x57dfbd(0x106)][_0x57dfbd(0x132)](this),this['initVariableGauges']();},Game_System[_0x457acf(0x134)]['initVariableGauges']=function(){const _0x174177=_0x457acf;this[_0x174177(0xfe)]=VisuMZ['VariableGauges'][_0x174177(0xf6)][_0x174177(0x16b)](),this[_0x174177(0x154)]=VisuMZ[_0x174177(0x138)]['DefaultBattleVisibleGauges'][_0x174177(0x16b)](),this[_0x174177(0x161)]=!![];},Game_System['prototype']['visibleVariableGauges']=function(){const _0x193d30=_0x457acf;if(this[_0x193d30(0xfe)]===undefined)this[_0x193d30(0x199)]();if(this[_0x193d30(0x154)]===undefined)this[_0x193d30(0x199)]();if(SceneManager[_0x193d30(0x174)]()){let _0x280903=this['_mapVisibleVariableGauges']['clone']();if($gameMap){if($gameMap[_0x193d30(0x10c)]())return[];else{if($gameMap[_0x193d30(0x16d)]()[_0x193d30(0x13c)]>0x0)return $gameMap[_0x193d30(0x16d)]();}$gameMap['visibleVariableGauges']()[_0x193d30(0x13c)]>0x0&&(_0x280903=_0x280903[_0x193d30(0x13a)]($gameMap['visibleVariableGauges']()));}return _0x280903[_0x193d30(0x164)]((_0x4dc650,_0x3f934c,_0x5d5104)=>_0x5d5104[_0x193d30(0x13e)](_0x4dc650)===_0x3f934c);}else return SceneManager[_0x193d30(0x198)]()?this[_0x193d30(0x154)]:[];},Game_System[_0x457acf(0x134)][_0x457acf(0x1a9)]=function(_0x54d625){const _0x440f70=_0x457acf;return _0x54d625=_0x54d625[_0x440f70(0xf3)]()['trim'](),this['visibleVariableGauges']()['includes'](_0x54d625);},Game_System[_0x457acf(0x134)]['addMapVisibleVariableGauge']=function(_0x11b461){const _0x1d3806=_0x457acf;if(this[_0x1d3806(0xfe)]===undefined)this[_0x1d3806(0x199)]();_0x11b461=_0x11b461[_0x1d3806(0xf3)]()[_0x1d3806(0x118)]();if(!VisuMZ[_0x1d3806(0x138)][_0x1d3806(0x136)][_0x11b461])return;!this['_mapVisibleVariableGauges'][_0x1d3806(0x121)](_0x11b461)&&(this[_0x1d3806(0xfe)][_0x1d3806(0x1a8)](_0x11b461),SceneManager[_0x1d3806(0x174)]()&&SceneManager[_0x1d3806(0x16c)][_0x1d3806(0x12d)](_0x11b461));},Game_System[_0x457acf(0x134)]['removeMapVisibleVariableGauge']=function(_0x1f4924){const _0x54890e=_0x457acf;if(this[_0x54890e(0xfe)]===undefined)this[_0x54890e(0x199)]();_0x1f4924=_0x1f4924['toUpperCase']()[_0x54890e(0x118)](),this['_mapVisibleVariableGauges'][_0x54890e(0x121)](_0x1f4924)&&(this[_0x54890e(0xfe)][_0x54890e(0x103)](_0x1f4924),SceneManager[_0x54890e(0x174)]()&&SceneManager['_scene'][_0x54890e(0x110)](_0x1f4924));},Game_System[_0x457acf(0x134)][_0x457acf(0xf5)]=function(_0x5d63d5){const _0x8fc6fd=_0x457acf;if(this[_0x8fc6fd(0x154)]===undefined)this['initVariableGauges']();_0x5d63d5=_0x5d63d5[_0x8fc6fd(0xf3)]()[_0x8fc6fd(0x118)]();if(!VisuMZ['VariableGauges']['GaugeKey'][_0x5d63d5])return;!this[_0x8fc6fd(0x154)][_0x8fc6fd(0x121)](_0x5d63d5)&&(this['_battleVisibleVariableGauges'][_0x8fc6fd(0x1a8)](_0x5d63d5),SceneManager[_0x8fc6fd(0x198)]()&&SceneManager[_0x8fc6fd(0x16c)][_0x8fc6fd(0x12d)](_0x5d63d5));},Game_System[_0x457acf(0x134)]['removeBattleVisibleVariableGauge']=function(_0x4cd404){const _0x2bc83b=_0x457acf;if(this[_0x2bc83b(0x154)]===undefined)this[_0x2bc83b(0x199)]();_0x4cd404=_0x4cd404[_0x2bc83b(0xf3)]()['trim'](),this[_0x2bc83b(0x154)][_0x2bc83b(0x121)](_0x4cd404)&&(this[_0x2bc83b(0x154)]['remove'](_0x4cd404),SceneManager['isSceneBattle']()&&SceneManager[_0x2bc83b(0x16c)][_0x2bc83b(0x110)](_0x4cd404));},Game_System['prototype'][_0x457acf(0x11a)]=function(){const _0x2d54ad=_0x457acf;if(this[_0x2d54ad(0x161)]===undefined)this[_0x2d54ad(0x199)]();return this[_0x2d54ad(0x161)];},Game_System[_0x457acf(0x134)][_0x457acf(0x15a)]=function(_0x3af4e5){const _0x340394=_0x457acf;if(this[_0x340394(0x161)]===undefined)this[_0x340394(0x199)]();this['_variableGaugeVisibile']=_0x3af4e5;const _0x50f3d2=SceneManager[_0x340394(0x16c)];_0x50f3d2&&_0x50f3d2['updateVariableGaugeVisibility']();},VisuMZ['VariableGauges'][_0x457acf(0x10b)]=Game_Variables['prototype'][_0x457acf(0x1b3)],Game_Variables['prototype']['setValue']=function(_0x309f6c,_0x5aa160){const _0x33639b=_0x457acf;VisuMZ[_0x33639b(0x138)][_0x33639b(0x10b)][_0x33639b(0x132)](this,_0x309f6c,_0x5aa160),this[_0x33639b(0x19f)](_0x309f6c);},Game_Variables[_0x457acf(0x134)][_0x457acf(0x19f)]=function(_0x586517){const _0x3fdeca=_0x457acf;if(!SceneManager[_0x3fdeca(0x198)]()&&!SceneManager[_0x3fdeca(0x174)]())return;if(VisuMZ[_0x3fdeca(0x138)][_0x3fdeca(0x16f)][_0x586517]){const _0x611978=VisuMZ[_0x3fdeca(0x138)][_0x3fdeca(0x16f)][_0x586517];for(const _0x544b28 of _0x611978){SceneManager[_0x3fdeca(0x16c)][_0x3fdeca(0x18f)](_0x544b28);}}},Game_Map[_0x457acf(0x134)][_0x457acf(0x10c)]=function(){const _0x4cb9d4=_0x457acf;if($dataMap){const _0xe52bf5=VisuMZ[_0x4cb9d4(0x138)][_0x4cb9d4(0x151)],_0x172a6e=$dataMap[_0x4cb9d4(0x11e)]||'';if(_0x172a6e[_0x4cb9d4(0x1ac)](_0xe52bf5[_0x4cb9d4(0x102)]))return!![];}return![];},Game_Map[_0x457acf(0x134)][_0x457acf(0x16d)]=function(){const _0x55fa64=_0x457acf;if($dataMap){const _0x334b15=VisuMZ['VariableGauges'][_0x55fa64(0x151)],_0x34fbef=$dataMap[_0x55fa64(0x11e)]||'';if(_0x34fbef['match'](_0x334b15['ForcedGauges'])){const _0x3cd344=String(RegExp['$1'])[_0x55fa64(0x1ab)](',')['map'](_0x3cfae2=>_0x3cfae2[_0x55fa64(0xf3)]()[_0x55fa64(0x118)]());return _0x3cd344;}}return[];},Game_Map[_0x457acf(0x134)][_0x457acf(0x190)]=function(){const _0xb6751f=_0x457acf;if($dataMap){const _0x55703=VisuMZ[_0xb6751f(0x138)]['RegExp'],_0x529e6e=$dataMap[_0xb6751f(0x11e)]||'';if(_0x529e6e[_0xb6751f(0x1ac)](_0x55703[_0xb6751f(0x1a2)])){const _0x130796=String(RegExp['$1'])[_0xb6751f(0x1ab)](',')[_0xb6751f(0x1ae)](_0x3c7a1c=>_0x3c7a1c['toUpperCase']()['trim']());return _0x130796;}}return[];},VisuMZ[_0x457acf(0x138)]['Scene_Base_createWindowLayer']=Scene_Base['prototype']['createWindowLayer'],Scene_Base[_0x457acf(0x134)]['createWindowLayer']=function(){const _0x4e6bb7=_0x457acf;this[_0x4e6bb7(0x168)](),this[_0x4e6bb7(0x162)](),this[_0x4e6bb7(0x17f)](),VisuMZ['VariableGauges']['Scene_Base_createWindowLayer'][_0x4e6bb7(0x132)](this),this[_0x4e6bb7(0xf0)]();},Scene_Base[_0x457acf(0x134)][_0x457acf(0x168)]=function(){const _0x102a46=_0x457acf;this['_variableGaugeLayer']=new Sprite(),this[_0x102a46(0x188)](this[_0x102a46(0x185)]);},Scene_Base[_0x457acf(0x134)]['createVariableGaugeSprites']=function(){const _0x193289=_0x457acf,_0x52bbb0=$gameSystem[_0x193289(0x190)]();for(let _0x21db76 of _0x52bbb0){_0x21db76=_0x21db76[_0x193289(0xf3)]()['trim']();if(!VisuMZ[_0x193289(0x138)][_0x193289(0x136)][_0x21db76])continue;this['createNewVariableGaugeSprites'](_0x21db76);}},Scene_Base[_0x457acf(0x134)][_0x457acf(0x12d)]=function(_0x3d2d3f){const _0x3d2a4a=_0x457acf;_0x3d2d3f=_0x3d2d3f['toUpperCase']()['trim']();if($gameMap){if($gameMap[_0x3d2a4a(0x10c)]())return;if($gameMap[_0x3d2a4a(0x16d)]()[_0x3d2a4a(0x13c)]>0x0){if(!$gameMap[_0x3d2a4a(0x16d)]()[_0x3d2a4a(0x121)](_0x3d2d3f))return;}}const _0x324101=this[_0x3d2a4a(0x185)][_0x3d2a4a(0xfc)],_0x2e3f99=_0x324101[_0x3d2a4a(0xf2)](_0x953987=>_0x953987['_key']===_0x3d2d3f);if(!_0x2e3f99){const _0x31fad3=new Sprite_VariableGauge(_0x3d2d3f);this[_0x3d2a4a(0x185)][_0x3d2a4a(0x188)](_0x31fad3);}},Scene_Base[_0x457acf(0x134)][_0x457acf(0x18f)]=function(_0x5706ca){const _0x3118b8=_0x457acf;_0x5706ca=_0x5706ca['toUpperCase']()[_0x3118b8(0x118)]();const _0x356bee=this[_0x3118b8(0x185)][_0x3118b8(0xfc)],_0x234211=_0x356bee[_0x3118b8(0xf2)](_0x2eba0e=>_0x2eba0e['_key']===_0x5706ca);_0x234211&&_0x234211['refresh']();},Scene_Base[_0x457acf(0x134)][_0x457acf(0x110)]=function(_0xae8a5d){const _0x433b46=_0x457acf;_0xae8a5d=_0xae8a5d[_0x433b46(0xf3)]()[_0x433b46(0x118)]();const _0xe262d3=this[_0x433b46(0x185)][_0x433b46(0xfc)],_0x212676=_0xe262d3[_0x433b46(0xf2)](_0x2db853=>_0x2db853[_0x433b46(0x12e)]===_0xae8a5d);_0x212676&&this[_0x433b46(0x185)]['removeChild'](_0x212676);},Scene_Base[_0x457acf(0x134)][_0x457acf(0xf0)]=function(){const _0x405d05=_0x457acf;this['_variableGaugeTooltipWindow']=new Window_VariableGaugeTooltip(),this[_0x405d05(0x188)](this[_0x405d05(0x112)]);},Scene_Base['prototype']['updateVariableGaugeVisibility']=function(){const _0xc82462=_0x457acf;this[_0xc82462(0x185)]&&(this[_0xc82462(0x185)][_0xc82462(0x111)]=$gameSystem[_0xc82462(0x11a)]());},VisuMZ['VariableGauges'][_0x457acf(0x19e)]=Scene_Battle['prototype'][_0x457acf(0x1ad)],Scene_Battle['prototype']['setVisibleUI']=function(_0x45bfe2){const _0x4b17d8=_0x457acf;VisuMZ[_0x4b17d8(0x138)][_0x4b17d8(0x19e)][_0x4b17d8(0x132)](this,_0x45bfe2),this[_0x4b17d8(0x185)]&&(this['_variableGaugeLayer'][_0x4b17d8(0x111)]=_0x45bfe2&&$gameSystem[_0x4b17d8(0x11a)]());};function _0x3bc5(_0x3217d5,_0x1b4260){const _0x3edad9=_0x3eda();return _0x3bc5=function(_0x3bc5da,_0x1b62ed){_0x3bc5da=_0x3bc5da-0xef;let _0x530da7=_0x3edad9[_0x3bc5da];return _0x530da7;},_0x3bc5(_0x3217d5,_0x1b4260);}function _0x3eda(){const _0x298bad=['isSceneMap','convertMessageKeywords','floor','create','updateIconPosition','IconSet','getColor','ARRAYSTR','width','initialize','isSupportMessageKeywords','updateVariableGaugeVisibility','ARRAYNUM','isOptionValid','WINDOW_SKIN_OPACITY','JSON','drawGauge','_variableGaugeLayer','SystemVariableGaugeVisibility','Scene_Boot_onDatabaseLoaded','addChild','hide','Visiblility','return\x200','adjustBitmap','IconIndex','10977439bbLidM','refreshVariableGauge','visibleVariableGauges','padding','DefaultBattleVisibleGauges','setupText','gaugeBackColor','isWordWrapEnabled','number','DefaultBattleVisible','isSceneBattle','initVariableGauges','setFrame','adjustPosition','update','updateRefreshRequest','Scene_Battle_setVisibleUI','updateVariableGauges','_lastRate','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','VisibleGauges','WINDOW_SCALE','OffsetX','isBusy','STR','ConvertParams','push','isVariableGaugeVisible','isHorizontal','split','match','setVisibleUI','map','clear','loadSystem','onMouseExit','bitmap','setValue','settings','version','MapRemoveAllGauge','_iconSprite','createVariableGaugeTooltipWindow','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','find','toUpperCase','opacity','addBattleVisibleVariableGauge','DefaultMapVisibleGauges','_hoverState','60164GOxiDb','format','drawGaugeBack','itemPadding','children','OffsetY','_mapVisibleVariableGauges','ARRAYSTRUCT','scale','description','HideGauges','remove','exit','14KfNyhS','Game_System_initialize','FUNC','constructor','DefaultMapVisible','Tooltip','Game_Variables_setValue','hideVariableGauges','parse','_iconIndex','windowskin','removeVariableGauge','visible','_variableGaugeTooltipWindow','iconHeight','WindowSkin','Key','>>>ATTENTION<<<','Please\x20change\x20this\x20to\x20an\x20appropriate\x20key\x20name.','trim','name','areVariableGaugesVisible','max','applyInverse','MapRemoveGauge','note','71923992ELwTSe','getGaugeRate','includes','15VHZtfF','clamp','STRUCT','clampPosition','_requestRefresh','targetWindow','8ovidIg','6PYypqC','removeMapVisibleVariableGauge','height','refresh','createNewVariableGaugeSprites','_key','updateBackOpacity','3713650eQjzbO','WINDOW_SKIN_FILENAME','call','onMouseEnter','prototype','fillRect','GaugeKey','parameters','VariableGauges','backOpacity','concat','Settings','length','updateIconSpriteFrame','indexOf','addMapVisibleVariableGauge','updatePosition','updateOpacity','isBeingTouched','setKey','resetFontSettings','drawGaugeFront','NUM','You\x20have\x20a\x20Variable\x20Gauge\x20key\x20named\x20>>>ATTENTION<<<\x0a','iconWidth','processTouch','1590DUnJGR','Scale','VariableID','BattleAddGauge','Keys','horz','ARRAYFUNC','RegExp','MOUSE_OFFSET_Y','value','_battleVisibleVariableGauges','registerCommand','PositionJS','_text','76500mjPoku','createContents','setVariableGaugesVisible','EVAL','resizeWindow','MOUSE_OFFSET_X','updateIconSprite','gradientFillRect','createIconSprite','_variableGaugeVisibile','createVariableGaugeSprites','refreshBitmap','filter','WindowOpacity','resize','Color2','createVariableGaugeLayer','2255778GMmTLW','setupKeywordText','clone','_scene','forcedVariableGauges','onDatabaseLoaded','VariableReference','round','worldTransform','217403dxldky','IconBuffer'];_0x3eda=function(){return _0x298bad;};return _0x3eda();}function Sprite_VariableGauge(){const _0x235edc=_0x457acf;this[_0x235edc(0x17d)](...arguments);}Sprite_VariableGauge[_0x457acf(0x134)]=Object['create'](Sprite_Clickable[_0x457acf(0x134)]),Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x108)]=Sprite_VariableGauge,Sprite_VariableGauge['prototype'][_0x457acf(0x17d)]=function(_0x7980ef){const _0x235e3f=_0x457acf;Sprite_Clickable[_0x235e3f(0x134)][_0x235e3f(0x17d)]['call'](this),this[_0x235e3f(0x12e)]=_0x7980ef['toUpperCase']()[_0x235e3f(0x118)](),this['_requestRefresh']=![],this[_0x235e3f(0x163)](),this[_0x235e3f(0x160)]();},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x1b4)]=function(){const _0x39eb0c=_0x457acf;return VisuMZ[_0x39eb0c(0x138)]['GaugeKey'][this[_0x39eb0c(0x12e)]];},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x1aa)]=function(){const _0x21aeed=_0x457acf;return this[_0x21aeed(0x1b4)]()['Type']===_0x21aeed(0x14f);},Sprite_VariableGauge['prototype'][_0x457acf(0x19c)]=function(){const _0x195107=_0x457acf;Sprite_Clickable['prototype']['update'][_0x195107(0x132)](this),this['updateRefreshRequest'](),this[_0x195107(0x13d)]();},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x160)]=function(){const _0x1aee3d=_0x457acf;this['_iconSprite']=new Sprite(),this[_0x1aee3d(0x188)](this[_0x1aee3d(0xef)]),this[_0x1aee3d(0xef)][_0x1aee3d(0x1b2)]=ImageManager[_0x1aee3d(0x1b0)](_0x1aee3d(0x179)),this[_0x1aee3d(0x15e)]();},Sprite_VariableGauge['prototype'][_0x457acf(0x15e)]=function(){const _0xfd4e06=_0x457acf;this[_0xfd4e06(0x178)](),this['updateIconSpriteFrame']();},Sprite_VariableGauge['prototype']['updateIconPosition']=function(){const _0xbbd1e0=_0x457acf;if(!this[_0xbbd1e0(0xef)])return;const _0x4d2b67=this[_0xbbd1e0(0x1b4)]()[_0xbbd1e0(0x173)];this['isHorizontal']()?(this[_0xbbd1e0(0xef)]['x']=-ImageManager[_0xbbd1e0(0x148)]-_0x4d2b67,this[_0xbbd1e0(0xef)]['y']=Math['round']((this[_0xbbd1e0(0x1b2)]['height']-ImageManager[_0xbbd1e0(0x113)])/0x2)):(this[_0xbbd1e0(0xef)]['x']=Math[_0xbbd1e0(0x170)]((this['bitmap'][_0xbbd1e0(0x17c)]-ImageManager[_0xbbd1e0(0x148)])/0x2),this['_iconSprite']['y']=this[_0xbbd1e0(0x1b2)][_0xbbd1e0(0x12b)]+_0x4d2b67);},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x13d)]=function(){const _0x41ce7a=_0x457acf;if(!this[_0x41ce7a(0xef)])return;if(this[_0x41ce7a(0x10e)]===this['settings']()[_0x41ce7a(0x18d)])return;this[_0x41ce7a(0x10e)]=this[_0x41ce7a(0x1b4)]()[_0x41ce7a(0x18d)];const _0x632368=ImageManager['iconWidth'],_0x38fd26=ImageManager['iconHeight'],_0x402879=this[_0x41ce7a(0x10e)]%0x10*_0x632368,_0x5717a9=Math[_0x41ce7a(0x176)](this[_0x41ce7a(0x10e)]/0x10)*_0x38fd26;this[_0x41ce7a(0xef)][_0x41ce7a(0x19a)](_0x402879,_0x5717a9,_0x632368,_0x38fd26);},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x12c)]=function(){const _0x45b7ca=_0x457acf;this[_0x45b7ca(0x126)]=!![];},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x19d)]=function(){const _0x13e793=_0x457acf;if(!this[_0x13e793(0x126)])return;this[_0x13e793(0x163)](),this[_0x13e793(0x126)]=![];},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x163)]=function(){const _0xfb5038=_0x457acf,_0x4f7666=this[_0xfb5038(0x1b4)]()[_0xfb5038(0x156)]['call'](this);this[_0xfb5038(0x19b)](_0x4f7666),this[_0xfb5038(0x18c)](_0x4f7666),this[_0xfb5038(0x184)](_0x4f7666);},Sprite_VariableGauge['prototype'][_0x457acf(0x19b)]=function(_0x411c4a){this['x']=_0x411c4a['x'],this['y']=_0x411c4a['y'];},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x18c)]=function(_0x7daa25){const _0x5927d0=_0x457acf;this[_0x5927d0(0x1b2)]?(this[_0x5927d0(0x1b2)][_0x5927d0(0x17c)]!==_0x7daa25[_0x5927d0(0x17c)]||this[_0x5927d0(0x1b2)][_0x5927d0(0x12b)]!==_0x7daa25[_0x5927d0(0x12b)])&&(this[_0x5927d0(0x1b2)][_0x5927d0(0x166)](_0x7daa25[_0x5927d0(0x17c)],_0x7daa25['height']),this[_0x5927d0(0x15e)]()):this[_0x5927d0(0x1b2)]=new Bitmap(_0x7daa25[_0x5927d0(0x17c)],_0x7daa25[_0x5927d0(0x12b)]);},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x120)]=function(){const _0x5afb28=_0x457acf,_0x5616bf=this[_0x5afb28(0x1b4)]()[_0x5afb28(0x14c)];let _0x4de1cd=$gameVariables[_0x5afb28(0x153)](_0x5616bf)||0x0;if(typeof _0x4de1cd!==_0x5afb28(0x196))_0x4de1cd=0x0;const _0x5a8329=this[_0x5afb28(0x1b4)]()['MaximumJS'][_0x5afb28(0x132)](this),_0x17ab03=(_0x4de1cd/_0x5a8329)[_0x5afb28(0x123)](0x0,0x1);return _0x17ab03;},Sprite_VariableGauge[_0x457acf(0x134)]['drawGauge']=function(_0x440868){const _0x217755=_0x457acf,_0x454a0c=this['getGaugeRate']();if(this[_0x217755(0x1a0)]===_0x454a0c)return;this[_0x217755(0x1a0)]=_0x454a0c,this[_0x217755(0xfa)](_0x440868),this['drawGaugeFront'](_0x440868);},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0xfa)]=function(_0x2c47b0){const _0x41eae2=_0x457acf,_0x1d8e8d=ColorManager[_0x41eae2(0x194)]();this[_0x41eae2(0x1b2)][_0x41eae2(0x135)](0x0,0x0,_0x2c47b0[_0x41eae2(0x17c)],_0x2c47b0['height'],_0x1d8e8d);},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x145)]=function(_0x25b03a){const _0x4c11fc=_0x457acf,_0x52272c=this[_0x4c11fc(0x120)](),_0x3af937=ColorManager[_0x4c11fc(0x17a)](this[_0x4c11fc(0x1b4)]()['Color1']),_0x11530b=ColorManager[_0x4c11fc(0x17a)](this[_0x4c11fc(0x1b4)]()[_0x4c11fc(0x167)]),_0x279573=this['isHorizontal'](),_0x3c4157=_0x279573?Math[_0x4c11fc(0x176)]((_0x25b03a['width']-0x2)*_0x52272c):_0x25b03a[_0x4c11fc(0x17c)]-0x2,_0x1deed4=_0x279573?_0x25b03a['height']-0x2:Math['floor']((_0x25b03a[_0x4c11fc(0x12b)]-0x2)*_0x52272c),_0x12fa8a=_0x279573?0x1:_0x25b03a['height']-0x1-_0x1deed4,_0x11aa04=_0x279573?_0x3af937:_0x11530b,_0x16c344=_0x279573?_0x11530b:_0x3af937;this[_0x4c11fc(0x1b2)][_0x4c11fc(0x15f)](0x1,_0x12fa8a,_0x3c4157,_0x1deed4,_0x11aa04,_0x16c344,!_0x279573);},Sprite_VariableGauge[_0x457acf(0x134)]['targetWindow']=function(){const _0xb744d3=_0x457acf;return SceneManager['_scene'][_0xb744d3(0x112)];},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x133)]=function(){const _0x3e4c95=_0x457acf;Sprite_Clickable[_0x3e4c95(0x134)]['onMouseEnter']['call'](this);const _0x45edc5=this[_0x3e4c95(0x127)]();_0x45edc5&&_0x45edc5[_0x3e4c95(0x143)](this[_0x3e4c95(0x12e)]);},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x1b1)]=function(){const _0x45f72c=_0x457acf;Sprite_Clickable[_0x45f72c(0x134)][_0x45f72c(0x1b1)][_0x45f72c(0x132)](this);const _0x3aa962=this['targetWindow']();_0x3aa962&&_0x3aa962['_key']===this[_0x45f72c(0x12e)]&&_0x3aa962[_0x45f72c(0x143)](null);},Sprite_VariableGauge[_0x457acf(0x134)][_0x457acf(0x149)]=function(){const _0x29bfc3=_0x457acf,_0x5afac9=this[_0x29bfc3(0xf7)];this['_hoverState']=this[_0x29bfc3(0x142)](),this[_0x29bfc3(0xf7)]!==_0x5afac9&&(this[_0x29bfc3(0xf7)]?this[_0x29bfc3(0x133)]():this[_0x29bfc3(0x1b1)]());},Sprite_VariableGauge['prototype']['isBeingTouched']=function(){const _0x9caee5=_0x457acf;if($gameMessage[_0x9caee5(0x1a5)]())return![];const _0x182fb6=new Point(TouchInput['x'],TouchInput['y']),_0x41bd9a=this[_0x9caee5(0x171)][_0x9caee5(0x11c)](_0x182fb6);return this['hitTest'](_0x41bd9a['x'],_0x41bd9a['y']);};function Window_VariableGaugeTooltip(){const _0x10f401=_0x457acf;this[_0x10f401(0x17d)](...arguments);}Window_VariableGaugeTooltip[_0x457acf(0x134)]=Object[_0x457acf(0x177)](Window_Base[_0x457acf(0x134)]),Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x108)]=Window_VariableGaugeTooltip,Window_VariableGaugeTooltip[_0x457acf(0x1a3)]=VisuMZ[_0x457acf(0x138)][_0x457acf(0x13b)][_0x457acf(0x10a)][_0x457acf(0x14b)],Window_VariableGaugeTooltip[_0x457acf(0x131)]=VisuMZ['VariableGauges'][_0x457acf(0x13b)][_0x457acf(0x10a)][_0x457acf(0x114)],Window_VariableGaugeTooltip['WINDOW_SKIN_OPACITY']=VisuMZ[_0x457acf(0x138)][_0x457acf(0x13b)]['Tooltip'][_0x457acf(0x165)],Window_VariableGaugeTooltip['MOUSE_OFFSET_X']=VisuMZ[_0x457acf(0x138)][_0x457acf(0x13b)][_0x457acf(0x10a)][_0x457acf(0x1a4)],Window_VariableGaugeTooltip[_0x457acf(0x152)]=VisuMZ[_0x457acf(0x138)]['Settings'][_0x457acf(0x10a)][_0x457acf(0xfd)],Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x17d)]=function(){const _0x2d3946=_0x457acf,_0x10419c=new Rectangle(0x0,0x0,Graphics[_0x2d3946(0x17c)],Graphics[_0x2d3946(0x12b)]);Window_Base['prototype'][_0x2d3946(0x17d)]['call'](this,_0x10419c),this[_0x2d3946(0x100)]['x']=this[_0x2d3946(0x100)]['y']=Window_VariableGaugeTooltip[_0x2d3946(0x1a3)],this[_0x2d3946(0x189)](),this['_key']='';},Window_VariableGaugeTooltip['prototype']['loadWindowskin']=function(){const _0xd3c8a4=_0x457acf;this[_0xd3c8a4(0x10f)]=ImageManager[_0xd3c8a4(0x1b0)](Window_VariableGaugeTooltip[_0xd3c8a4(0x131)]);},Window_VariableGaugeTooltip['prototype'][_0x457acf(0x12f)]=function(){const _0x5874f8=_0x457acf;this[_0x5874f8(0x139)]=Window_VariableGaugeTooltip[_0x5874f8(0x182)];},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x143)]=function(_0x300ae9){const _0xbb3b24=_0x457acf;if(this[_0xbb3b24(0x12e)]===_0x300ae9)return;if(_0x300ae9!==null&&!VisuMZ[_0xbb3b24(0x138)][_0xbb3b24(0x136)][_0x300ae9])return;this[_0xbb3b24(0x12e)]=_0x300ae9||'',this[_0xbb3b24(0x12e)][_0xbb3b24(0x118)]()['length']>0x0?this[_0xbb3b24(0x12c)]():this[_0xbb3b24(0x189)]();},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x12c)]=function(){const _0x151164=_0x457acf;this['contents'][_0x151164(0x1af)](),this[_0x151164(0x193)]();if(this[_0x151164(0x157)][_0x151164(0x13c)]>0x0){this[_0x151164(0x15c)]();const _0x17b079=this['baseTextRect']();this['drawTextEx'](this[_0x151164(0x157)],_0x17b079['x'],_0x17b079['y'],_0x17b079['width']),this['show']();}else this[_0x151164(0x189)]();},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x195)]=function(){return![];},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x175)]=function(_0x308631){return _0x308631;},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x17e)]=function(){return![];},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x193)]=function(){const _0x4779ef=_0x457acf;this[_0x4779ef(0x157)]='';if(!this[_0x4779ef(0x12e)])return;this[_0x4779ef(0x16a)](),this[_0x4779ef(0x157)]=this[_0x4779ef(0x157)][_0x4779ef(0x118)]();},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x16a)]=function(){const _0xee1b24=_0x457acf,_0x372340=VisuMZ[_0xee1b24(0x138)]['GaugeKey'][this[_0xee1b24(0x12e)]];this[_0xee1b24(0x157)]=_0x372340['TooltipText']||'';},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x15c)]=function(){const _0xa37789=_0x457acf,_0x439e80=this['textSizeEx'](this[_0xa37789(0x157)]);this[_0xa37789(0x17c)]=_0x439e80[_0xa37789(0x17c)]+(this[_0xa37789(0xfb)]()+this[_0xa37789(0x191)])*0x2,this[_0xa37789(0x12b)]=_0x439e80[_0xa37789(0x12b)]+this[_0xa37789(0x191)]*0x2,this[_0xa37789(0x159)](),this[_0xa37789(0x144)]();},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x19c)]=function(){const _0x3c94d1=_0x457acf;Window_Base[_0x3c94d1(0x134)][_0x3c94d1(0x19c)][_0x3c94d1(0x132)](this),this[_0x3c94d1(0x126)]&&(this[_0x3c94d1(0x126)]=![],this[_0x3c94d1(0x12c)]()),this[_0x3c94d1(0x140)](),this[_0x3c94d1(0x141)]();},Window_VariableGaugeTooltip['prototype']['requestRefresh']=function(){this['_requestRefresh']=!![];},Window_VariableGaugeTooltip[_0x457acf(0x134)]['updatePosition']=function(){const _0x928983=_0x457acf;if(!this[_0x928983(0x111)])return;this['x']=TouchInput['x']+Window_VariableGaugeTooltip[_0x928983(0x15d)],this['y']=TouchInput['y']+Window_VariableGaugeTooltip[_0x928983(0x152)],this['clampPosition']();},Window_VariableGaugeTooltip[_0x457acf(0x134)][_0x457acf(0x125)]=function(){const _0x28edc1=_0x457acf,_0x26c759=this[_0x28edc1(0x17c)]*(Window_VariableGaugeTooltip[_0x28edc1(0x1a3)]||0.01),_0x363764=this[_0x28edc1(0x12b)]*(Window_VariableGaugeTooltip[_0x28edc1(0x1a3)]||0.01);this['x']=Math['round'](this['x'][_0x28edc1(0x123)](0x0,Graphics[_0x28edc1(0x17c)]-_0x26c759)),this['y']=Math[_0x28edc1(0x170)](this['y'][_0x28edc1(0x123)](0x0,Graphics[_0x28edc1(0x12b)]-_0x363764));},Window_VariableGaugeTooltip['prototype'][_0x457acf(0x141)]=function(){const _0x5039e0=_0x457acf;let _0x55c70f=0xff;if(TouchInput['x']<=0x0)_0x55c70f=0x0;if(TouchInput['x']>=Graphics[_0x5039e0(0x17c)])_0x55c70f=0x0;if(TouchInput['y']<=0x0)_0x55c70f=0x0;if(TouchInput['y']>=Graphics[_0x5039e0(0x12b)])_0x55c70f=0x0;this[_0x5039e0(0xf4)]=_0x55c70f;};